	function N = CA_CONST_R_ORDER_S(Wc, Ws, Amin)
	
	% 	Computes required order for an analog lowpass Cauer 
	%	filter with constant pole radius.
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1999-9-27
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	x = 10^(0.1*Amin);
	Amax = 10*log10(x/(x-1));
	
	N = CA_ORDER_S(Wc, Ws, Amax, Amin);
	
	% check
	%	ep = sqrt(10^(Amax0/10)-1)
	%	es = sqrt(10^(Amin/10)-1)
	
